### 实验名称

实验1 Xiaomi AIoT 开发平台介绍

### 实验目的

通过该实验的学习与实践：

了解Xiaomi AIoT 开发平台的组成及使用

### 实验背景

​	“一箱打包小米技术”，Xiaomi AIoT 开发平台（又称Xiaomi AIoT 实训箱）是小米自研的一类新型的嵌入式智能化开发平台，采用模块化的设计方法，能够高效、灵活的实现定制化的智能硬件系统搭建。利用该平台搭建产品雏形，从而让后续的基础软件、通讯应用、AI应用、移动互联网应用等开发与硬件可视化的进行结合，是能够承载小米最佳实践、凸显软硬件融合特色、有效联系理论教学与产品开发的特色化平台。

### 建议课时

2课时

### 实验步骤

本实验为初步介绍，更多内容请查看XIAOMI AIoT开发平台说明书。

<video src="../video/开箱介绍.mp4"></video>

一、开箱介绍

1. 小米实训箱包含一个铝箱以及子板收纳塑料箱。打开箱子，整体包含母板、子板、线缆和备件。

   ![2](pic/2.jpg)

   ​												图1 开发平台布局

   <video src="../video/xm-01.mp4"></video>

2. 母板（M1）上有若干接口以及开关键。其中：

   ![1](pic/1.jpg)

   ​											图2 母板布局图

   •供电口：使用55W电源进行供电。

   •开关机：长按开关键，待绿色指示灯亮起后松手，母板上电完成开机；长按开关键，待绿色指示灯熄灭后松手，母板断电完成关机。

   •错误警报：任意槽位电流超过2A时会触发告警机制，红色错误指示灯亮，母板自动切断该槽位电源。

   •USB1、USB2接口：连接外部USB设备，如鼠标、键盘、U盘等。

   •Micro USB接口：U1子板、C1子板、C2子板程序下载调试用此接口。

   •Type-B接口：USB下载口，用于U2板子程序下载。

   •以太网口：10/100M自适应以太网口，RJ45接口。

   • 0#-5#收纳槽：摆放子板使用，采用磁吸方式连接。

   槽口设计，#0为类似平行四边形的设计，意味着只能放U板，#1~#5的槽口设计为5个口。外侧四个口用于摆放子板。剩余的一个口用于适应U板。

   <video src="../video/xm-02.mp4"></video>

3. 子板包括U板、C板、B板、S板、E板。

   ![3](pic/3.jpg)

   ​												图3 子板分类图

   U板为核心控制子板。包含单片机U1板和带有Ubuntu系统的U2板。

   C板为通信子板。包含C1小米WiFi+BLE、C2ZigBee、C3通用WiFi+BLEHE C4NBIoT模块。

   B板为扩展子板，当母板或子板接口不够时使用。包含B1子板扩展、B2母板扩展和B3多协议接口扩展。

   S板为传感器子板，用于数据读取、输入。S1按键、S2光照传感器、S3麦克风、S4摄像头、S5NFC读写器、S6超声波测距传感器、S7人体红外传感器、S8温湿度传感器。

   E板为执行器子板，用于输出，实现控制。包含E1三色LED和数码管、E2风扇、E3窗帘机、E4扬声器、E5触控屏。

   <video src="../video/xm-03.mp4"></video>

   子板采用磁吸方式连接。除U板外，子板下方接口呈倒梯形，摆放时，让梯形的宽的一条边在上，放入槽位的槽口中即可。另外，子板一个侧边有子板型号标识。让其朝向左边即可。

   常用堆叠方式：U+C、U+E、U+S、U+E4+E、U+E4+S、U+E4+C+S/E。

   除E4外，S和E上不堆叠子板。另外，堆叠的前提是，子板上有子板接收口，像E4上有接收口，可以向上堆叠；其他S和E没有，则不能堆叠。

   <video src="../video/xm-04.mp4"></video>

二、操作演示

1. 母板平放，放上U1，S7，插上电源，长按母板电源，电源亮绿灯，松开，母板上电成功。子板电源指示灯常亮（多为红色），为子板上电成功。另外，S7本身带有人体感应状态灯，取下上盖，可以看到，状态灯亮起，说明S7工作正常。

   <video src="../video/xm-05.mp4"></video>

2. GD-LINK调试器链接方式，延长线——调试器——SWD调试转接线（M1），USB端接上后，调试器长亮绿光，闪红光。

   ![5](pic/5.jpg)![6](pic/6.jpg)

   ​									图4、5 调试器与转接线连接方式

   <video src="../video/xm-06.mp4"></video>

三、注意事项

1. 母板，即M1，使用时用放在水平面上

2. 母板上电/关闭，需长按电源

3. U板使用时放#0，#1槽位的最下层

4. 0#槽位只能放置U板，1#—5#槽位可以放置任意类型子板

5. 子板插拔时，子板和母板都有对应槽口.设计

6. 子板侧面有子板字符标识，子板插入母板时，让字符标识朝左

   ![4](pic/4.jpg)

7. 任意槽位电流超过2A时会触发告警机制，红色错误指示灯亮。出现此情况时。可进行设备断电，并移除负载；设备再次上电，槽位报警可解除。

8. 插拔子板之前，都需保证母板断电

9. U板与U板之间不允许纵向堆叠

10. U板和其他子板进行纵向堆叠时，U板必须位于最下层。

11. 程序下载更新及开发调试时，只能插接在母板上的0#或1#槽位

12. C1和C2在使用前，要注意拨码位置，都是左侧拨码朝下，右侧拨码朝上

    ![7](pic/7.jpg)

13. B1子板不可放置在U板、E4、C板之上。

14. 常用堆叠方式：U+C、U+E、U+S、U+E4+E、U+E4+S、U+E4+C+S/E

    ![8](pic/8.jpg)

15. **本节只提了及部分常用的注意事项，还有其他注意事项，请查看XIAOMI AIoT开发平台说明书**

### 实验总结

通过本实验希望同学们能够了解Xiaomi AIoT 开发平台及其使用。